#!/usr/bin/perl --
###############################################################################
# ShoutDisplay.pl: Part of the Shoutbox 2.3.1 Mod
# Copyright:       2005 Andrew Aitken (LoonyPandora)

# Version:         Shoutbox 2.3.1 b0.8

# Released:        1st Febuaury, 2009

# Distributed By:  http://www.boardmod.org

# 2.3.1 update by: Batchman, Derek Barnstorm, D0T-C0M, Driven, with permission
###############################################################################

$shoutdisplayplver = 'Shoutbox Mod 231 b0.8';



# Make sure the module path is present

# Some servers need all the subdirs in @INC too.

push(@INC, "./Modules");

push(@INC, "./Modules/Upload");

push(@INC, "./Modules/Digest");



if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/) {

	$yyIIS = 1;

	$0 =~ m~(.*)(\\|/)~;

	$yypath = $1;

	$yypath =~ s~\\~/~g;

	chdir($yypath);

	push(@INC, $yypath);

}


#use Time::HiRes qw(time);
    #benchmarking
#
$START_TIME = time;


&DisplayShouts;


sub DisplayShouts {


	require "Paths.pl";

	require "$vardir/Settings.pl";

	require "$sourcedir/Subs.pl";

	require "$sourcedir/Load.pl";

	require "$vardir/Smilies.txt";

	require "$vardir/shoutsettings.txt";


	$scripturl = qq~$boardurl/YaBB.$yyext~;


	&LoadLanguage("Shoutbox");

	&LoadLanguage("Main");

	&LoadCookie;

	&UserCheck($username,"template+timeselect+timeoffset+language+lp_shout_refresh+lp_shout_timestamp+lp_shout_smileys+lp_shout_bbcode");


	# Figure out which template to be using.

	${$uid.$username}{'template'} = $usercheck{$username.'template'};

	&WhatTemplate;


	# Guardian Form spoofing protection

	# $masterseed = substr($date, length($date) - 4, length($date));

	# $formsession = &encode_session($mbname, $masterseed);

	# $formsession .= $masterseed;


	# Set guests censor language

	if ($iamguest) { our $language = $censor_lang; }
	else { $language = $usercheck{$username.'language'} }

	fopen(SHOUTS, "$vardir/shouts.txt");
	@shouts = <SHOUTS>;

	fclose(SHOUTS);


	$number_of_shouts = $#shouts;

	$skip_shouts      = ($number_of_shouts - $max_disp_shouts);

	$counter          = 0;


	if ($reverse_post) {
 @shouts = reverse @shouts;
 }


	if (!$INFO{'showall'}) {

		foreach $shoutline (@shouts) {

			if ($counter > $skip_shouts) {

				chomp @shouts;

				($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);


				&CheckCanDelete;


				# Censor the posts, and display names

				if ($enable_censor) {

					&LoadCensorList;

					$shout_displayname = &Censor($shout_displayname);

					$shout_message     = &Censor($shout_message);

				}


				# Do UBBC on the Shout (append shout_ before vars)

				$message = $shout_message;

				&wrap;

				if ($enable_ubbc) {

					if (!$yyYaBBCloaded) {

						require "$sourcedir/YaBBC.pl";

					}

					&DoUBBC;

				}

				&my_wrap3;
				if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
				$shout_message = $message;

				$shout_time = &shout_timeformat($shout_time);

				# Set the alternating backgrounds colours
				if ($counter % 2) { $class = 'shout_windowbg'; }
				else { $class = 'shout_windowbg2'; }

				if ($usercheck{$username.'lp_shout_timestamp'}) { $timestamp = "<i>$shout_time</i><br />"; }

				$shout_rows .= qq~
  <tr>
	<td class="$class" title="$shout_time" style="font-size: 10px;">
	  $timestamp<a href="$scripturl?action=viewprofile;username=$shout_username" class="shoutbox-username-style" target="_parent"><b>$shout_displayname:</b></a> $shout_message    $delete_link
	</td>
  </tr>~;

			}
			$counter++;
		}

		$shoutform_action = "$scripturl?action=write_shouts";
		&Template;

	} else {

		foreach $shoutline (@shouts) {
			chomp @shouts;
			($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);

			# Censor the posts, and display names
			if ($enable_censor) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			# Do UBBC on the Shout (append shout_ before vars)
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;
			if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
			$shout_message = $message;

			$shout_time = &shout_timeformat($shout_time);

			# Set the alternating backgrounds colours
			if ($counter % 2) { $class = 'shout_windowbg'; }
			else { $class = 'shout_windowbg2'; }

			if ($usercheck{$username.'lp_shout_timestamp'}) { $timestamp = "<i>$shout_time</i><br />"; }

			$shout_rows .= qq~
  <tr>
	<td class="$class" title="$shout_time" style="font-size: 10px;">
	  $timestamp<a href="$scripturl?action=viewprofile;username=$shout_username" class="shoutbox-username-style" target="_parent"><b>$shout_displayname:</b></a> $shout_message    $delete_link
	</td>
  </tr>~;

			$counter++;
		}

		$shoutform_action = "$scripturl?action=write_shouts;showall=1";

		&Template;
	}
}

sub CheckCanDelete {
      if ($delete_delay == "0") { return; }
 
      if ( ${$uid.$username}{'realname'} eq $shout_name || $iamadmin) {
            my $now_time = int(time);

		if (($now_time - $shout_time) <= $delete_delay) {
			$delete_link = qq~<a href="$scripturl?action=useremoveshouts;shout=$shout_time">X</a>~;
		}
	}
}

sub my_wrap3 {
	$shout_message =~ s~(<.*>)*(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)?(<.*>)*~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~(<.*>)?(\S{0,14})(\S{0,14})?(\S{0,14})?(\S{0,14})?(\S*)(<\/\S*>)~$1$2 $3 $4 $5 $6$7~gi;
	$shout_message =~ s~\s+~ ~gi;
}

sub shout_timeformat {
	$oldformat = $_[0];
	chomp $oldformat;
	if (!$oldformat) { return $oldformat; }
	$dontusetoday = $_[1];
	$mytimeselected = $usercheck{$username.'timeselect'} || $timeselected;
	(undef, undef, undef, undef, undef, undef, undef, undef, $newisdst) = localtime($oldformat);
	if ($newisdst > 0) { $userdst = $usercheck{$username.'dsttimeoffset'} || $dstoffset; $dst = 1; }

	# we find out what time the date of the post is according to the users timezone.
	if ($iamguest) {
		$toffs   = $timeoffset;
		$dstoffs = $dstoffset;
	} else {
		$toffs   = $usercheck{$username.'timeoffset'};
		$dstoffs = $userdst;
	}
	my ($newsecond, $newminute, $newhour, $newday, $newmonth, $newyear, $newweekday, $newyearday, $dummy) = gmtime($oldformat + (3600 * ($toffs + $dstoffs)));

	# Calculate number of full weeks this year
	$newweek = int(($newyearday + 1 - $newweekday) / 7) + 1;

	# Add 1 if today isn't Saturday
	if ($newweekday < 6) { $newweek = $newweek + 1; }
	$newweek = sprintf("%02d", $newweek);
	$newmonth++;
	$newweekday++;
	$newyear += 1900;
	$newshortyear = substr($newyear, 2, 2);
	$newmonth = sprintf("%02d", $newmonth);
	if ($mytimeselected != 4) { $newday = sprintf("%02d", $newday); }
	$newhour   = sprintf("%02d", $newhour);
	$newminute = sprintf("%02d", $newminute);
	$newsecond = sprintf("%02d", $newsecond);

	$newtime = $newhour . ":" . $newminute . ":" . $newsecond;

	($secx, $minx, $hourx, $dd, $mm, $yy, $tmpx, $yd, $tmpx) = gmtime($date + (3600 * ($toffs + $dstoffs)));

	$mm = $mm + 1;
	$yy = ($yy % 100);

	$daytxt = "";

	#the today yesterday problem was here... =(
	if (!$dontusetoday) {
		if ($yd == $newyearday && $yy == $newshortyear) {

			# today
			$daytxt = qq~$shout_txt{'28'}~;
		} elsif (($yd == $newyearday + 1 && $yy == $newshortyear) || ($yd == 1 && $dd == 31 && $yy == $newshortyear + 1)) {

			# yesterday
			$daytxt = qq~$shout_txt{'28a'}~;
		} elsif (($yd == $newyearday - 365 && $yy == $newshortyear + 1) || ($yd == $newyearday - 366 && $yy == $newshortyear + 1)) {

			# yesterday, over a year end.
			$daytxt = qq~$shout_txt{'28a'}~;
		}
	}

	if (!$maintxt{'107'}) { $maintxt{'107'} = $admin_txt{'107'}; }

	if ($mytimeselected == 7) {
		$mytimeformat = $usercheck{$username.'timeformat'};
		if ($mytimeformat =~ m/MM/) { $usefullmonth = 1; }
		if ($mytimeformat =~ m/hh/) { $hourstyle    = 12; }
		if ($mytimeformat =~ m/HH/) { $hourstyle    = 24; }
		$mytimeformat =~ s/\@/$maintxt{'107'}/g;
		$mytimeformat =~ s/mm/$newminute/g;
		$mytimeformat =~ s/ss/$newsecond/g;
		$mytimeformat =~ s/ww/$newweek/g;

		if ($mytimeformat =~ m/\+/) {
			if ($newday > 10 && $newday < 20) {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			} elsif ($newday % 10 == 1) {
				$dayext = "<sup>$timetxt{'1'}</sup>";
			} elsif ($newday % 10 == 2) {
				$dayext = "<sup>$timetxt{'2'}</sup>";
			} elsif ($newday % 10 == 3) {
				$dayext = "<sup>$timetxt{'3'}</sup>";
			} else {
				$dayext = "<sup>$timetxt{'4'}</sup>";
			}
		}
		if ($hourstyle == 12) {
			$ampm = $newhour > 11 ? 'pm' : 'am';
			$newhour2 = $newhour % 12 || 12;
			$mytimeformat =~ s/hh/$newhour2/g;
			$mytimeformat =~ s/\#/$ampm/g;
		} elsif ($hourstyle == 24) {
			$mytimeformat =~ s/HH/$newhour/g;
		}
		if ($daytxt eq "") {
			$mytimeformat =~ s/YYYY/$newyear/g;
			$mytimeformat =~ s/YY/$newshortyear/g;
			$mytimeformat =~ s/DD/$newday/g;
			$mytimeformat =~ s/D/$newday/g;
			$mytimeformat =~ s/\+/$dayext/g;
			if ($usefullmonth == 1) {
				$mytimeformat =~ s/MM/$months[$newmonth-1]/g;
			} else {
				$mytimeformat =~ s/M/$newmonth/g;
			}
		} else {
			$mytimeformat =~ s/DD/$daytxt/g;
			$mytimeformat =~ s/D/$daytxt/g;
			$mytimeformat =~ s/YY//g;
			$mytimeformat =~ s/M//g;
			$mytimeformat =~ s/\+//g;
		}
		if ($newisdst && $usercheck{$username.'dsttimeoffset'} != 0) {
			$mytimeformat =~ s/\*/$maintxt{'dst'}/g;
		} else {
			$mytimeformat =~ s/\*//g;
		}
		$newformat = $mytimeformat;
	} elsif ($mytimeselected == 1) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newmonth/$newday/$newshortyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 2) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newday.$newmonth.$newshortyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 3) {
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newtime~ : qq~$newday.$newmonth.$newyear $maintxt{'107'} $newtime~;
	} elsif ($mytimeselected == 4) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newmonth2 = $months[$newmonth - 1];
		if ($newday > 10 && $newday < 20) {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		} elsif ($newday % 10 == 1) {
			$newday2 = "<sup>$timetxt{'1'}</sup>";
		} elsif ($newday % 10 == 2) {
			$newday2 = "<sup>$timetxt{'2'}</sup>";
		} elsif ($newday % 10 == 3) {
			$newday2 = "<sup>$timetxt{'3'}</sup>";
		} else {
			$newday2 = "<sup>$timetxt{'4'}</sup>";
		}
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~$newmonth2 $newday$newday2, $newyear, $newhour2:$newminute$ampm~;
	} elsif ($mytimeselected == 5) {
		$ampm = $newhour > 11 ? 'pm' : 'am';
		$newhour2 = $newhour % 12 || 12;
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour2:$newminute$ampm~ : qq~$newmonth/$newday/$newshortyear $maintxt{'107'} $newhour2:$newminute$ampm~;
	} elsif ($mytimeselected == 6) {
		$newmonth2 = $months[$newmonth - 1];
		$newformat = $daytxt ? qq~$daytxt $maintxt{'107'} $newhour:$newminute~ : qq~$newday. $newmonth2 $newyear $maintxt{'107'} $newhour:$newminute~;
	}
	return $newformat;
}

sub Timer {
	$time_running = time - $START_TIME;
	$time_running = sprintf("%.4f", $time_running);
	print qq~

<!-- Ran for $time_running seconds  -  Accessed $file_open files-->
~;

}


sub ShowExtras {
	# Multiply by 1000, because JS uses millseconds
	if ($usercheck{$username.'lp_shout_refresh'} >= 10) {
		$refresh = ($usercheck{$username.'lp_shout_refresh'}*1000);
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
	setTimeout("reload_page()", $refresh);
}

/* Reloads page if message is default or blank */
function reload_page() {
	if (document.shoutbox.message.value == "") {
		window.location.reload();
	}
}
		~;
	} else {
		$refresh_js = qq~
/* Scrolls page, and sets timer for autorefreshing */
function timer() {
	window.scrollTo(0,99999);
}
		~;
	}

	if ($usercheck{$username.'lp_shout_smileys'}) {
		$smiley_bar = qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
	HAND = "style='cursor: pointer;'";
	document.write("<img src='$imagesdir/smiley.gif' onclick='smiley();' "+HAND+" align=bottom alt='$post_txt{'287'}' border='0'> ");
	document.write("<img src='$imagesdir/wink.gif' onclick='wink();' "+HAND+" align=bottom alt='$post_txt{'292'}' border='0'> ");
	document.write("<img src='$imagesdir/cheesy.gif' onclick='cheesy();' "+HAND+" align=bottom alt='$post_txt{'289'}' border='0'> ");
	document.write("<img src='$imagesdir/grin.gif' onclick='grin();' "+HAND+" align=bottom alt='$post_txt{'293'}' border='0'> ");
	document.write("<img src='$imagesdir/angry.gif' onclick='angry();' "+HAND+" align=bottom alt='$post_txt{'288'}' border='0'> ");
	document.write("<img src='$imagesdir/sad.gif' onclick='sad();' "+HAND+" align=bottom alt='$post_txt{'291'}' border='0'> ");
	document.write("<img src='$imagesdir/shocked.gif' onclick='shocked();' "+HAND+" align=bottom alt='$post_txt{'294'}' border='0'> ");
	document.write("<img src='$imagesdir/cool.gif' onclick='cool();' "+HAND+" align=bottom alt='$post_txt{'295'}' border='0'> ");
	document.write("<img src='$imagesdir/huh.gif' onclick='huh();' "+HAND+" align=bottom alt='$post_txt{'296'}' border='0'> ");
	document.write("<img src='$imagesdir/rolleyes.gif' onclick='rolleyes();' "+HAND+" align=bottom alt='$post_txt{'450'}' border='0'> ");
	document.write("<img src='$imagesdir/tongue.gif' onclick='tongue();' "+HAND+" align=bottom alt='$post_txt{'451'}' border='0'> ");
	document.write("<img src='$imagesdir/embarassed.gif' onclick='embarassed();' "+HAND+" align=bottom alt='$post_txt{'526'}' border='0'> ");
	document.write("<img src='$imagesdir/lipsrsealed.gif' onclick='lipsrsealed();' "+HAND+" align=bottom alt='$post_txt{'527'}' border='0'> ");
	document.write("<img src='$imagesdir/undecided.gif' onclick='undecided();' "+HAND+" align=bottom alt='$post_txt{'528'}' border='0'> ");
	document.write("<img src='$imagesdir/kiss.gif' onclick='kiss();' "+HAND+" align=bottom alt='$post_txt{'529'}' border='0'> ");
	document.write("<img src='$imagesdir/cry.gif' onclick='cry();' "+HAND+" align=bottom alt='$post_txt{'530'}' border='0'> ");$moresmilieslist
} else {
	document.write("<span  class='small'>$post_txt{'215'}</span>");
}
//-->
</script>
		~;
	}

	if ($usercheck{$username.'lp_shout_bbcode'} && $enable_ubbc) {
		$bbcode_bar = qq~
<script language="JavaScript1.2" type="text/javascript">
<!--
if((navigator.appName == "Netscape" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Microsoft Internet Explorer" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Opera" && navigator.appVersion.charAt(0) >= 4) || (navigator.appName == "Konqueror" && navigator.appVersion.charAt(0) >= 2)) {
		HAND = "style='cursor: pointer;'";
		document.write("<img src='$imagesdir/bold.gif' onclick='bold();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'253'}' border=0>");
		document.write("<img src='$imagesdir/italicize.gif' onclick='italicize();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'254'}' border='0'>");
		document.write("<img src='$imagesdir/underline.gif' onclick='underline();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'255'}' border='0'>");
		document.write("<img src='$imagesdir/strike.gif' onclick='strike();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'441'}' border='0'>");
		document.write("<img src='$imagesdir/move.gif' onclick='move();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'439'}' border='0'>");
		document.write("<img src='$imagesdir/size.gif' onclick='size();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'532'}' border='0'>");
		document.write("<img src='$imagesdir/face.gif' onclick='font();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'533'}' border='0'>");
		document.write("<img src='$imagesdir/url.gif' onclick='hyperlink();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'257'}' border='0'>");
		document.write("<img src='$imagesdir/email2.gif' onclick='emai1();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'258'}' border='0'>");
		document.write("<img src='$imagesdir/sup.gif' onclick='superscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'447'}' border='0'>");
		document.write("<img src='$imagesdir/sub.gif' onclick='subscript();' "+HAND+" align=bottom width=23 height=22 alt='$post_txt{'448'}' border='0'>");
} else {
	document.write("<span  class='small'>$post_txt{'215'}</span>");
}
//-->
</script>

		~;
	}
}


sub Template {
	&ShowExtras;
	print qq~Content-type:text/html\n\n~;
	print qq~<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Shoutbox</title>
<meta http-equiv="Content-Type" content="text/html; charset=$yycharset" />
<meta http-equiv="pragma" content="no-cache" />
<link rel="stylesheet" href="$forumstylesurl/$usestyle.css" type="text/css" />
<script language="JavaScript1.2" src="$yyhtml_root/shoutnew.js" type="text/javascript"></script>
<script language="JavaScript1.2" type="text/javascript">
<!--
/* Opens windows for smilies and previous shouts */
function openWindow(theURL,winName,features) {
  window.open(theURL,winName,features);
}

/* clears default values from input boxes */
function clearText(thefield) {
	if (thefield.defaultValue==thefield.value)
	thefield.value = ""
}

/* Uses hidden form fields so message never disappears accidentally */


function changevalue() {
	if (document.shoutbox.message.defaultValue == document.shoutbox.message.value)
		{
		alert("$shout_txt{'45'}");
		return false;
		}
	else
		{
		document.shoutbox.shoutout.value = document.shoutbox.message.value;
		document.shoutbox.message.value = "";
		}
 }



$refresh_js
// -->
</script>

</head>

<body onload="timer()">
<table width="360" cellpadding="1" cellspacing="0" style="position: left; bottom: 0px;">

$shout_rows

  <tr>
	<td class="shoutbox-post-style" align="center">
		$bbcode_bar<br />
		$smiley_bar
		<form name="shoutbox" action="$shoutform_action" method="post" onSubmit="changevalue()">
			<input type="hidden" name="shoutout" maxlength="$max_shout_length" /><br />
			<input type="hidden" name="formsession" value="$mbname$username" />
			<input type="text" name="message" size="35" maxlength="$max_shout_length" onfocus="clearText(this)" value="" />
			<input type="submit" name="Submit" value="$shout_txt{'31'}" />
		</form>

		<br />
		<a href="./ShoutDisplay.pl?showall=1" target="_new">$shout_txt{'32'}</a>
		&nbsp;//&nbsp;
		<a href="javascript:openWindow('$scripturl?action=shout_smilies','smilies','scrollbars=yes,width=360,height=300')">$shout_txt{'33'}</a>
	<br />
    	<a href="javascript:window.location.reload();">$shout_txt{'34'}</a>
	</td>
  </tr>

</table>
~;

	&Timer;

	print qq~
</body>
</html>
~;


}


1;
